#ifndef STDV3D_H_INCLUDED
#define STDV3D_H_INCLUDED

#if _MSC_VER >= 1100
   #pragma warning (disable : 4714)
   #pragma warning (disable : 4702) // impossible d'atteindre le code
#endif

#if _MSC_VER >= 1100
#define _ALLOW_KEYWORD_MACROS
#define inline __forceinline
#pragma inline_depth(255)
#endif

#include <cassert>
#include <algorithm>
#include <functional>
//#include <limits>

#include <iostream>

#include <vector>
#include <list>
#include <stack>
#include <map>

#ifdef _DEBUG
	#define DEBUG_DEV(i) i
#else
	#define DEBUG_DEV(i) 
#endif


namespace V3D
{
    typedef float LengthType;

    typedef __int8 int8;
    typedef __int16 int16;
    typedef __int32 int32;
    typedef __int64 int64;

    typedef unsigned __int8 uint8;
    typedef unsigned __int16 uint16;
    typedef unsigned __int32 uint32;
    typedef unsigned __int64 uint64;
};

#define MAX_INT8   0x7f
#define MIN_INT8   0x80
#define MAX_UINT8  0xffu

#define MAX_INT16  0x7fff
#define MIN_INT16  0x8000
#define MAX_UINT16 0xffffu

#define MAX_INT32  0x7fffffff
#define MIN_INT32  0x80000000
#define MAX_UINT32 0xffffffffu

#define MAX_INT64  0x7fffffffffffffff
#define MIN_INT64  0x8000000000000000
#define MAX_UINT64 0xffffffffffffffffu

#define MAX_UINT (~0u)

#define MAX_FLOAT32 3.402823466e+38F
#define MIN_FLOAT32 -3.402823466e+38F

#define MAX_FLOAT64 1.7976931348623158e+308
#define MIN_FLOAT64 -1.7976931348623158e+308

#define MAX_DOUBLE MAX_FLOAT64


#endif // #ifndef STDV3D_H_INCLUDED
